// ZTest.cpp - Copyright (C) 2000 Pat Thoyts <pat@zsplat.freeserve.co.uk>
//
// Implementation of the ZTest COM object
//
// @(#)$Id: ZTest.cpp,v 1.1.1.1 2000/11/20 02:10:46 pat Exp $

#define INITGUID
#include "ZTest.h"

STDMETHODIMP 
CZTest::QueryInterface(REFIID riid, void** ppv)
{
    HRESULT hr = S_OK;
    *ppv = 0;
    
    if (riid == IID_IUnknown || riid == IID_IZTest)
        *ppv = static_cast<IZTest*>(this);
    else
        hr = E_NOINTERFACE;
    
    static_cast<IUnknown*>(*ppv)->AddRef();
    return hr;
}

STDMETHODIMP_(ULONG) 
CZTest::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG) 
CZTest::Release()
{
    if (InterlockedDecrement(&m_lRefCount) == 0)
    {
        delete this;
        return 0;
    }
    return m_lRefCount;
}

STDMETHODIMP 
CZTest::Message(const char* msg)
{
    ::MessageBox(NULL, msg, "Message", MB_OK | MB_ICONASTERISK);
    return S_OK;
}

// Local variables:
//   mode: c++
//   indent-tabs-mode: nil
//   c-file-style: "stroustrup"
// End:
